/*
 * Decompiled with CFR 0.152.
 */
package oracle.ldap.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final byte[] charset = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
    private static byte[] binaryCodes = new byte[256];

    public static String encode(String string) {
        String string2 = null;
        if (string != null) {
            string2 = new String(Base64.encode(string.getBytes()));
        }
        return string2;
    }

    public static String utfEncode(String string) {
        String string2 = null;
        try {
            if (string != null) {
                string2 = new String(Base64.encode(string.getBytes("UTF-8")), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public static String decode(String string) {
        String string2 = null;
        if (string != null) {
            string2 = new String(Base64.decode(string.getBytes()));
        }
        return string2;
    }

    public static String utfDecode(String string) {
        String string2 = null;
        try {
            if (string != null) {
                string2 = new String(Base64.decode(string.getBytes("UTF-8")), "UTF-8");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        return string2;
    }

    public static byte[] encode(byte[] byArray) {
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            boolean bl = false;
            boolean bl2 = false;
            int n3 = Base64.unsignedByteToInt(byArray[n]) << 8;
            if (n + 1 < byArray.length) {
                n3 |= Base64.unsignedByteToInt(byArray[n + 1]);
                bl = true;
            }
            n3 <<= 8;
            if (n + 2 < byArray.length) {
                n3 |= Base64.unsignedByteToInt(byArray[n + 2]);
                bl2 = true;
            }
            byArray2[n2 + 3] = (byte)(bl2 ? charset[n3 & 0x3F] : 61);
            byArray2[n2 + 2] = (byte)(bl ? charset[(n3 >>= 6) & 0x3F] : 61);
            byArray2[n2 + 1] = charset[(n3 >>= 6) & 0x3F];
            byArray2[n2 + 0] = charset[(n3 >>= 6) & 0x3F];
            n += 3;
            n2 += 4;
        }
        return byArray2;
    }

    public static byte[] decode(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (binaryCodes[byArray[n2]] < 0) {
                --n;
            }
            ++n2;
        }
        int n3 = (n + 3) / 4 * 3;
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (n7 < byArray.length) {
            byte by = binaryCodes[byArray[n7]];
            if (by >= 0) {
                n4 = n4 << 6 | by;
                if (n5 >= 2) {
                    byArray2[n6++] = (byte)(n4 >> (n5 -= 2) & 0xFF);
                } else {
                    n5 += 6;
                }
            }
            ++n7;
        }
        byte[] byArray3 = new byte[n6];
        System.arraycopy(byArray2, 0, byArray3, 0, n6);
        return byArray3;
    }

    private static int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println("usage:  java Base64 [-d] String");
            System.exit(0);
        }
        if ("-d".equalsIgnoreCase(stringArray[0])) {
            bl = true;
        }
        if (bl && stringArray.length == 1) {
            System.out.println("usage:  java Base64 [-d] String");
            System.exit(0);
        }
        if (bl) {
            String string = stringArray[1];
            String string2 = null;
            if (string != null) {
                string2 = new String(Base64.decode(string.getBytes()));
            }
            System.out.println("Encoded String : " + string);
            System.out.println("Decoded String : " + string2);
        } else {
            String string = stringArray[0];
            String string3 = null;
            if (string != null) {
                string3 = new String(Base64.encode(string.getBytes()));
            }
            System.out.println("Orginal String : " + string);
            System.out.println("Encoded String : " + string3);
        }
    }

    static {
        int n = 0;
        while (n < 256) {
            Base64.binaryCodes[n] = -1;
            ++n;
        }
        Base64.binaryCodes[43] = 62;
        Base64.binaryCodes[47] = 63;
        int n2 = 48;
        while (n2 <= 57) {
            Base64.binaryCodes[n2] = (byte)(52 + n2 - 48);
            ++n2;
        }
        int n3 = 97;
        while (n3 <= 122) {
            Base64.binaryCodes[n3] = (byte)(26 + n3 - 97);
            ++n3;
        }
        int n4 = 65;
        while (n4 <= 90) {
            Base64.binaryCodes[n4] = (byte)(n4 - 65);
            ++n4;
        }
    }
}

